package gov.va.med.mhv.portal.nsoc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import com.bea.p13n.util.encoding.EncodingUtil;

public class XSSServletRequestWrapper extends HttpServletRequestWrapper{

	public XSSServletRequestWrapper(HttpServletRequest request) {
		super(request);
		// TODO Auto-generated constructor stub
	}
	
	@Override
	public String[] getParameterValues(String parameter) {
		String[] values = super.getParameterValues(parameter);
	    if (values == null) {
	    	return null;
	    }
		 
	    int count = values.length;
	    String[] encodedValues = new String[count];
	    for (int i = 0; i < count; i++) {
	    	encodedValues[i] = EncodingUtil.encodeXSS(values[i]);
	    }
		return encodedValues;
	}

	@Override
	public String getParameter(String parameter) {
		String value = super.getParameter(parameter);
	    return EncodingUtil.encodeXSS(value);
	}
	
	@Override
	public String getHeader(String name) {
		String value = super.getHeader(name);
		return EncodingUtil.encodeXSS(value);
	}

}
